/////////////////////////////////////////////////////////////
// CINEMA SDK : OBJECTS      															 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_OBJECTPLUGIN_H
#define __C4D_OBJECTPLUGIN_H

#include "ge_math.h"
#include "c4d_objectdata.h"
#include "c4d_nodeplugin.h"

#define QUALIFIER_SHIFT	1
#define QUALIFIER_CTRL	2

#define DRAWPASS_OBJECT			0
#define DRAWPASS_BOX				1
#define DRAWPASS_HANDLES		2

struct OBJECTPLUGIN : public NODEPLUGIN
{
	BaseBitmap		*command_icon;

	void					(ObjectData::*GetDimension			)(PluginObject *op, Vector *mp, Vector *rad);
	Bool					(ObjectData::*Draw							)(PluginObject *op, LONG drawpass, BaseDraw *bd, BaseDrawHelp *bh);
	LONG					(ObjectData::*DetectHandle			)(PluginObject *op, BaseDraw *bd, LONG x, LONG y, LONG qualifier);
	Bool					(ObjectData::*MoveHandle				)(PluginObject *op, PluginObject *undo, const Matrix &tm, LONG hit_id, LONG qualifier);

	// generator
	BaseObject*		(ObjectData::*GetVirtualObjects)(PluginObject *op, HierarchyHelp *hh);

	// modifier
	Bool					(ObjectData::*ModifyObject			)(PluginObject *mod, BaseDocument *doc, BaseObject *op, const Matrix &op_mg, const Matrix &mod_mg, Real lod, LONG flags, BaseThread *thread);
	void					(ObjectData::*CheckDirty				)(PluginObject *op, BaseDocument *doc);
	
	// spline
	SplineObject* (ObjectData::*GetContour				)(PluginObject *op, BaseDocument *doc, Real lod, BaseThread *bt);

	// particle
	void					(ObjectData::*ModifyParticles		)(PluginObject *op, Particle *pp, BaseParticle *ss, LONG pcnt, Real diff);
	Bool					(ObjectData::*AddToExecution	  )(PluginObject *op, PriorityList *list);
	LONG					(ObjectData::*Execute						)(PluginObject *op, BaseDocument *doc, BaseThread *bt, LONG priority, LONG flags);

	void*	reserved[(32-11)*C4DPL_MEMBERMULTIPLIER-1];
};

#endif
